package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.entities.enums.PatientType;

/**
 * Created by Mauricio Santos on 20/04/2017.
 * Stores meta data about etbmanager indicator and also DHIS2 data set
 */
public enum TB11Block1Row {
    NEW_UNKNOWN("manag.tbform11.row1", "W138XF0670Y", "N6vpgXeOrW1", "H7xBG6RXf7N"),
    RELAPSES("PatientType.RELAPSE", "riFA6iQN7wg", "uXoH5oeizhd", "y1wV1FCNk88"),
    AFTER_FAILURE("PatientType.TREATMENT_AFTER_FAILURE", "ovGVNVSY1jg", "nIUxVQIuv6T", "xapSXzwngV2"),
    AFTER_LOSS_FOLLOWUP("PatientType.TREATMENT_AFTER_LOSS_FOLLOW_UP", "cvPi47PI1qw", "VhnshO7XNyq", "NX066FRW6Zp"),
    OTHERS_PREV_TREAT("PatientType.OTHER_PREVIOUSLY_TREATED", "tPn6FsYQ79R", "ipvqizVHOlf", "ri3VIjhCfrl"),
    TOTAL("global.total", null, null, null);

    String key;
    String table1DataElementId;
    String table2DataElementId;
    String table3DataElementId;

    TB11Block1Row(String k, String table1DataElementId, String table2DataElementId, String table3DataElementId){
        this.key = k;
        this.table1DataElementId = table1DataElementId;
        this.table2DataElementId = table2DataElementId;
        this.table3DataElementId = table3DataElementId;
    }

    public String getKey(){
        return key;
    }

    public String getTable1DataElementId() {
        return table1DataElementId;
    }

    public String getTable2DataElementId() {
        return table2DataElementId;
    }

    public String getTable3DataElementId() {
        return table3DataElementId;
    }

    /**
     * This method will return the TB12Row enum equivalent to the Patient Type passed as parameter
     * @param patientType Patient Type tested
     * @return the TB12Row correspondent to the patient type passed as parameter.
     */
    public static TB11Block1Row getPatientTypeAsRow(PatientType patientType){
        if (patientType == null) {
            return null;
        }

        switch (patientType) {
            case UNKNOWN_PREVIOUS_TB_TREAT:
            case NEW:
                return TB11Block1Row.NEW_UNKNOWN;
            case RELAPSE:
                return TB11Block1Row.RELAPSES;
            case TREATMENT_AFTER_FAILURE:
                return TB11Block1Row.AFTER_FAILURE;
            case TREATMENT_AFTER_LOSS_FOLLOW_UP:
                return TB11Block1Row.AFTER_LOSS_FOLLOWUP;
            case OTHER_PREVIOUSLY_TREATED:
                return TB11Block1Row.OTHERS_PREV_TREAT;
        }

        return null;
    }
}
